var leaderboardName, achievementName;
var leaderboardReverse;

/**** Edit Leaderboard ****/
function edit_leaderboard(id, lang) {
	leaderboardName=document.getElementById("name"+id).innerHTML;
	leaderboardReverse=document.getElementById("reverse"+id).innerHTML;
	document.getElementById("name"+id).innerHTML="<input type='text' class='form-control' id='name_text"+id+"' value='"+leaderboardName+"'>";
	if (lang=='fa') {
		document.getElementById("reverse"+id).innerHTML='<select id="reverse_text'+id+'" class="custom-select"><option value="1" >کم به زیاد</option><option value="2" >زیاد به کم</option></select>';
	} else {
		document.getElementById("reverse"+id).innerHTML='<select id="reverse_text'+id+'" class="custom-select"><option value="1" >Low to High</option><option value="2" >High to Low</option></select>';
	}
	document.getElementById("edit_button"+id).style.display="none";
	document.getElementById("save_button"+id).style.display="inline-block";
}

function save_leaderboard(id, lang) {
	var newname=document.getElementById("name_text"+id).value;
	var newreverse=document.getElementById("reverse_text"+id).value;
	
	if (window.XMLHttpRequest) {
		xmlhttp = new XMLHttpRequest();
	} else {
		xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
	}
	var url = "ajax.php?action=editLeaderboard&id=" + id + "&name="+newname + "&reverse="+newreverse;
		
	xmlhttp.open("GET", url, true);
	xmlhttp.onreadystatechange = function() {
		if (this.readyState == 4 && this.status == 200) {
			document.getElementById("edit_button"+id).style.display="inline-block";
			document.getElementById("save_button"+id).style.display="none";
			document.getElementById("message").style.display="block";
			if (xmlhttp.responseText==true) {
				document.getElementById("alert").className="alert alert-success";
				document.getElementById("name"+id).innerHTML=newname;
				if (lang=='fa') {
					document.getElementById("alert").innerHTML="جدول امتیاز ویرایش شد";
					document.getElementById("reverse"+id).innerHTML=(newreverse==1 ? "کم به زیاد" : "زیاد به کم");
				} else if (lang=='en') {
					document.getElementById("alert").innerHTML="Successfully edited leaderboard";
					document.getElementById("reverse"+id).innerHTML=(newreverse==1 ? "Low to High" : "High to Low");
				}
			} else {
				document.getElementById("name"+id).innerHTML=leaderboardName;
				document.getElementById("reverse"+id).innerHTML=leaderboardReverse;
				document.getElementById("alert").className="alert alert-danger";
				if (lang=='fa') {
					document.getElementById("alert").innerHTML="خطایی در ویرایش جدول امتیاز رخ داده است";
				} else if (lang=='en') {
					document.getElementById("alert").innerHTML="Failed editing leaderboard";
				}
			}
			setTimeout(function() {
				$('#message').fadeOut('slow');
			}, 3000); 
		}
	};
	xmlhttp.send();
}

/**** Delete Leaderboard ****/
function delete_leaderboard(id, token, lang) {
    if (window.XMLHttpRequest) {
        xmlhttp = new XMLHttpRequest();
    } else {
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    var url = "ajax.php?action=deleteLeaderboard&id=" + id + "&token=" + token;

    xmlhttp.open("GET", url, true);
    xmlhttp.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
            document.getElementById("message").style.display = "block";
            if (xmlhttp.responseText == true) {
                document.getElementById("alert").className = "alert alert-success";
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "جدول امتیاز حذف شد";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Successfully deleted leaderboard";
                }
                var row = document.getElementById("row" + id);
                row.parentNode.removeChild(row);
            } else {
                document.getElementById("alert").className = "alert alert-danger";
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "خطایی در حذف جدول امتیاز رخ داده است";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Failed deleting leaderboard";
                }
            }
            setTimeout(function() {
                $('#message').fadeOut('slow');
            }, 3000);
        }
    };
    xmlhttp.send();
}

/**** Edit Achievement ****/
function edit_achievement(id, lang) {
	achievementName=document.getElementById("name"+id).innerHTML;
	document.getElementById("name"+id).innerHTML="<input type='text' style='width: 90%' class='form-control' id='name_text"+id+"' value='"+achievementName+"'>";
	document.getElementById("edit_button"+id).style.display="none";
	document.getElementById("save_button"+id).style.display="inline-block";
}

function save_achievement(id, lang) {
	var newname=document.getElementById("name_text"+id).value;
	if (window.XMLHttpRequest) {
		xmlhttp = new XMLHttpRequest();
	} else {
		xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
	}
	var url = "ajax.php?action=editAchievement&id=" + id + "&name="+ newname;
	xmlhttp.open("GET", url, true);
	xmlhttp.onreadystatechange = function() {
		if (this.readyState == 4 && this.status == 200) {
			document.getElementById("edit_button"+id).style.display="inline-block";
			document.getElementById("save_button"+id).style.display="none";
			document.getElementById("message").style.display="block";
			if (xmlhttp.responseText==true) {
				document.getElementById("name"+id).innerHTML=newname;
				document.getElementById("alert").className="alert alert-success";
				if (lang=='fa') {
					document.getElementById("alert").innerHTML="دستاورد ویرایش شد";
				} else if (lang=='en') {
					document.getElementById("alert").innerHTML="Successfully edited achievement";
				}
			} else {
				document.getElementById("name"+id).innerHTML=achievementName;
				document.getElementById("alert").className="alert alert-danger";
				if (lang=='fa') {
					document.getElementById("alert").innerHTML="خطایی در ویرایش دستاورد رخ داده است";
				} else if (lang=='en') {
					document.getElementById("alert").innerHTML="Failed editing achievement";
				}
			}
			setTimeout(function() {
				$('#message').fadeOut('slow');
			}, 3000); 
		}
	};
	xmlhttp.send();
}

/**** Delete Achievement ****/
function delete_achievement(id, token, lang) {
    if (window.XMLHttpRequest) {
        xmlhttp = new XMLHttpRequest();
    } else {
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    var url = "ajax.php?action=deleteAchievement&id=" + id + "&token=" + token;

    xmlhttp.open("GET", url, true);
    xmlhttp.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
            document.getElementById("message").style.display = "block";
            if (xmlhttp.responseText == true) {
                document.getElementById("alert").className = "alert alert-success";
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "دستاورد حذف شد";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Successfully deleted achievement";
                }
                var row = document.getElementById("row" + id);
                row.parentNode.removeChild(row);
            } else {
                document.getElementById("alert").className = "alert alert-danger";
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "خطایی در حذف دستاورد رخ داده است";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Failed deleting achievement";
                }
            }
            setTimeout(function() {
                $('#message').fadeOut('slow');
            }, 3000);
        }
    };
    xmlhttp.send();
}

/**** Edit Score ****/
function edit_score(userID) {
    scoreScore = document.getElementById("score_val" + userID).innerHTML;
    scoreName = document.getElementById("name_val" + userID).innerHTML;
    document.getElementById("score_val" + userID).innerHTML = "<input type='number' class='form-control' id='score_text" + userID + "' value='" + scoreScore + "'>";
    document.getElementById("name_val" + userID).innerHTML = "<input type='text' class='form-control' id='name_text" + userID + "' value='" + scoreName + "'>";
    document.getElementById("edit_button" + userID).style.display = "none";
    document.getElementById("save_button" + userID).style.display = "inline-block";
}

function save_score(userID, lbID, lbToken, lang) {
    var score = document.getElementById("score_text" + userID).value;
    var name = document.getElementById("name_text" + userID).value;

    if (window.XMLHttpRequest) {
        xmlhttp = new XMLHttpRequest();
    } else {
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    var url = "ajax.php?action=editScore&userID=" + userID + "&lbID=" + lbID + "&score=" + score + "&name=" + name + "&token=" + lbToken;

    xmlhttp.open("GET", url, true);
    xmlhttp.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
            document.getElementById("edit_button" + userID).style.display = "inline-block";
            document.getElementById("save_button" + userID).style.display = "none";
            document.getElementById("message").style.display = "block";
            if (xmlhttp.responseText == true) {
                document.getElementById("alert").className = "alert alert-success";
                document.getElementById("score_val" + userID).innerHTML = score;
                document.getElementById("name_val" + userID).innerHTML = name;
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "امتیاز ویرایش شد";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Successfully edited score";
                }
            } else {
                document.getElementById("score_val" + userID).innerHTML = scoreScore;
                document.getElementById("name_val" + userID).innerHTML = scoreName;
                document.getElementById("alert").className = "alert alert-danger";
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "خطایی در ویرایش امتیاز رخ داده است";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Failed editing score";
                }
            }
            setTimeout(function() {
                $('#message').fadeOut('slow');
            }, 3000);
        }
    };
    xmlhttp.send();
}

/**** Delete Score ****/
function delete_score(userID, lbID, token, lang) {
    if (window.XMLHttpRequest) {
        xmlhttp = new XMLHttpRequest();
    } else {
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    var url = "ajax.php?action=deleteScore&userID=" + userID + "&lbID=" + lbID + "&token=" + token;

    xmlhttp.open("GET", url, true);
    xmlhttp.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
            document.getElementById("message").style.display = "block";
            if (xmlhttp.responseText == true) {
                document.getElementById("alert").className = "alert alert-success";
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "امتیاز حذف شد";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Successfully deleted score";
                }
                var row = document.getElementById("row" + userID);
                row.parentNode.removeChild(row);
            } else {
                document.getElementById("alert").className = "alert alert-danger";
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "خطایی در حذف امتیاز رخ داده است";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Failed deleting score";
                }
            }
            setTimeout(function() {
                $('#message').fadeOut('slow');
            }, 3000);
        }
    };
    xmlhttp.send();
}

/**** Delete Hit ****/
function delete_hit(userID, achievementId, token, lang) {
    if (window.XMLHttpRequest) {
        xmlhttp = new XMLHttpRequest();
    } else {
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    var url = "ajax.php?action=deleteHit&userID=" + userID + "&achievementId=" + achievementId + "&token=" + token;

    xmlhttp.open("GET", url, true);
    xmlhttp.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
            document.getElementById("message").style.display = "block";
            if (xmlhttp.responseText == true) {
                document.getElementById("alert").className = "alert alert-success";
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "دستیابی حذف شد";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Successfully deleted hit";
                }
                var row = document.getElementById("row" + userID);
                row.parentNode.removeChild(row);
            } else {
                document.getElementById("alert").className = "alert alert-danger";
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "خطایی در حذف دستیابی رخ داده است";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Failed deleting hit";
                }
            }
            setTimeout(function() {
                $('#message').fadeOut('slow');
            }, 3000);
        }
    };
    xmlhttp.send();
}

/**** Add Score ****/
function add_score(leaderboardId, token, name, score, userID, lang) {
    if (window.XMLHttpRequest) {
        xmlhttp = new XMLHttpRequest();
    } else {
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    var url = "ajax.php?action=addScore&token=" + token + "&lbID=" + leaderboardId + "&score=" + score + "&name=" + name + "&userID=" + userID;
    xmlhttp.open("GET", url, true);
    xmlhttp.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
            document.getElementById("message").style.display = "block";
            console.log(xmlhttp.responseText);
            if (xmlhttp.responseText == true) {
                document.getElementById("alert").className = "alert alert-success";
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "امتیاز ثبت شد";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Successfully added score";
                }
            } else {
                document.getElementById("alert").className = "alert alert-danger";
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "خطایی در ثبت امتیاز رخ داده است";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Failed adding score";
                }
            }
            setTimeout(function() {
                $('#message').fadeOut('slow');
            }, 3000);
        }
    };
    xmlhttp.send();
}

/**** Add Hit ****/
function add_hit(achievementId, token, userID, lang) {
    if (window.XMLHttpRequest) {
        xmlhttp = new XMLHttpRequest();
    } else {
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    var url = "ajax.php?action=addHit&token=" + token + "&achievementId=" + achievementId + "&userID=" + userID;
    xmlhttp.open("GET", url, true);
    xmlhttp.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
            document.getElementById("message").style.display = "block";
            console.log(xmlhttp.responseText);
            if (xmlhttp.responseText == true) {
                document.getElementById("alert").className = "alert alert-success";
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "دستیابی ثبت شد";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Successfully added hit";
                }
            } else {
                document.getElementById("alert").className = "alert alert-danger";
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "خطایی در ثبت دستیابی رخ داده است";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Failed adding hit";
                }
            }
            setTimeout(function() {
                $('#message').fadeOut('slow');
            }, 3000);
        }
    };
    xmlhttp.send();
}


$(document).ready(function() {
	var colspan = 1;
	colspan = document.getElementById("no_score").colSpan;
	if (colspan!=6) {
		$('.scores tbody tr').eq(0).css("background", "#F1C40F");
		$('.scores tbody tr').eq(1).css("background", "#7F8C8D");
		$('.scores tbody tr').eq(2).css("background", "#9E6C4B");
		$('.scores tbody tr').each(function (idx) {
				$(this).children("td:eq(0)").html(idx + 1);
		});
	}
	console.log(colspan);
    $('#paginated').each(function() {
        var currentPage = 0;
        var numPerPage = 15;
        var $table = $(this);
        $table.bind('repaginate', function() {
            $table.find('tbody tr').hide().slice(currentPage * numPerPage, (currentPage + 1) * numPerPage).show();
        });
        $table.trigger('repaginate');
        var numRows = $table.find('tbody tr').length;
        var numPages = Math.ceil(numRows / numPerPage);
        var $pager = $('<div class="pager"></div>');
        for (var page = 0; page < numPages; page++) {
            $('<span class="page-number"></span>').text(page + 1).bind('click', {
                newPage: page
            }, function(event) {
                currentPage = event.data['newPage'];
                $table.trigger('repaginate');
                $(this).addClass('active').siblings().removeClass('active');
            }).appendTo($pager).addClass('clickable');
        }
        $pager.insertAfter($table).find('.page-number:first').addClass('active');
    });
    $('#paginated2').each(function() {
        var currentPage = 0;
        var numPerPage = 15;
        var $table = $(this);
        $table.bind('repaginate', function() {
            $table.find('tbody tr').hide().slice(currentPage * numPerPage, (currentPage + 1) * numPerPage).show();
        });
        $table.trigger('repaginate');
        var numRows = $table.find('tbody tr').length;
        var numPages = Math.ceil(numRows / numPerPage);
        var $pager = $('<div class="pager"></div>');
        for (var page = 0; page < numPages; page++) {
            $('<span class="page-number"></span>').text(page + 1).bind('click', {
                newPage: page
            }, function(event) {
                currentPage = event.data['newPage'];
                $table.trigger('repaginate');
                $(this).addClass('active').siblings().removeClass('active');
            }).appendTo($pager).addClass('clickable');
        }
        $pager.insertAfter($table).find('.page-number:first').addClass('active');
    });
});

/**************************************/
function prvcode(divname) {
    var testwin = document.getElementById(divname).value;
	console.log(testwin);
    al = window.open('', '', 'toolbar=no,width='+ document.getElementById('width').value +',height='+ document.getElementById('height').value +',directories=no,menubar=no,scrollbars=no');
    al.document.write('<center>' + testwin + '</center>');
}

function showCode(url, type, id, lang) {
    document.getElementById('htmlCode').value = '<!-- Start parscore embed code -->\n' +
        '<iframe src="' + url + 'frame.php?type='+ type + '&id='+ id + '&lang=' + lang + '" allowtransparency="true" marginwidth="0" marginheight="0" frameborder="0" scrolling="yes" width="' + document.getElementById('width').value + '" height="' + document.getElementById('height').value + '"></iframe>\n' +
        '<!-- End parscore embed code -->';
	if (lang == 'fa') {
		document.getElementById('alerttext').innerHTML = '<font color="red"> متن داخل کادر زیر را در سایت یا وبلاگ موردنظر کپی نمایید</font>';
	} else if (lang == 'en') {
		document.getElementById('alerttext').innerHTML = '<font color="red"> Copy this code in your website or blog</font>';
	}
}

/**** Delete Version ****/
function delete_version(id, lang) {
    if (window.XMLHttpRequest) {
        xmlhttp = new XMLHttpRequest();
    } else {
        xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    }
    var url = "ajax.php?action=deleteVersion&id=" + id;

    xmlhttp.open("GET", url, true);
    xmlhttp.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
            document.getElementById("message").style.display = "block";
            if (xmlhttp.responseText == true) {
                document.getElementById("alert").className = "alert alert-success";
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "نسخه حذف شد";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Successfully deleted version";
                }
                var row = document.getElementById("row" + id);
                row.parentNode.removeChild(row);
            } else {
                document.getElementById("alert").className = "alert alert-danger";
                if (lang == 'fa') {
                    document.getElementById("alert").innerHTML = "خطایی در حذف نسخه رخ داده است";
                } else if (lang == 'en') {
                    document.getElementById("alert").innerHTML = "Failed deleting version";
                }
            }
            setTimeout(function() {
                $('#message').fadeOut('slow');
            }, 3000);
        }
    };
    xmlhttp.send();
}

function addChange() {
	var newRow = $("<tr>");
	var cols = '<td><input type="text" class="form-control" name="changes[]" required></td><td style="width: 50px;"><button type="button" onclick="removeChange(this)" class="btn btn-danger"><i class="icon-remove"></i></button></td>';
	newRow.append(cols);
	$(".table").append(newRow);
}

function removeChange(id) {
	$(id).closest("tr").remove();
}